/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.autoconfigure.message;

import com.bxm.warcar.integration.autoconfigure.message.MessageProducerAutoConfiguration;
import com.bxm.warcar.integration.message.MessageProducer;
import com.bxm.warcar.integration.message.ThreadPoolMessageProducer;
import com.bxm.warcar.integration.message.annotation.Messaging;
import com.bxm.warcar.integration.message.annotation.MessagingRequest;
import com.bxm.warcar.integration.message.annotation.MessagingTopicField;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.concurrent.ExecutorService;
import javax.annotation.PreDestroy;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
@ConditionalOnBean(value={MessageProducer.class})
@AutoConfigureAfter(value={MessageProducerAutoConfiguration.class})
public class MessageAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageAspect.class);
    private final MessageProducer messageProducer;

    public MessageAspect(MessageProducer messageProducer) {
        this.messageProducer = messageProducer;
    }

    @PreDestroy
    public void destroy() {
        ExecutorService threadPool;
        MessageProducer producer = this.messageProducer;
        if (producer instanceof ThreadPoolMessageProducer && null != (threadPool = ((ThreadPoolMessageProducer)producer).getThreadPool())) {
            threadPool.shutdown();
        }
    }

    @AfterReturning(pointcut="@annotation(com.bxm.warcar.integration.message.annotation.Messaging)", returning="returning")
    public void doAfterReturning(JoinPoint point, Object returning) {
        Object[] args = point.getArgs();
        Method method = this.getMethod(point);
        if (null == method) {
            return;
        }
        if (null == returning) {
            return;
        }
        String topic = null;
        Object request = null;
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            MessagingTopicField messagingTopicField;
            Object arg = args[i];
            if (null == arg) continue;
            Parameter parameter = parameters[i];
            MessagingRequest messagingRequest = parameter.getAnnotation(MessagingRequest.class);
            if (null != messagingRequest) {
                request = arg;
            }
            if (null == (messagingTopicField = parameter.getAnnotation(MessagingTopicField.class))) continue;
            topic = arg.toString();
        }
        if (null == request) {
            request = args[0];
        }
        Messaging annotation = method.getAnnotation(Messaging.class);
        this.messageProducer.send(topic, request, returning, annotation);
    }

    private Method getMethod(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Class<?> targetClass = point.getTarget().getClass();
        try {
            return targetClass.getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getMethod:", (Throwable)e);
            }
            return null;
        }
    }

    public MessageProducer getMessageProducer() {
        return this.messageProducer;
    }
}

