package com.bxm.warcar.integration.autoconfigure.pair;

import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.integration.pair.local.LoadingCachePairImpl;
import com.bxm.warcar.integration.pair.redis.RedisPairImpl;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import redis.clients.jedis.JedisPool;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author allen
 * @since 1.0.0
 */
@Configuration
@EnableConfigurationProperties(PairProperties.class)
public class PairAutoConfiguration {

    @Bean
    @ConditionalOnBean(JedisPool.class)
    public RedisPairImpl redisPairImpl(JedisPool jedisPool) {
        return new RedisPairImpl(jedisPool);
    }

    @Configuration
    public static class LoadingCachePairAutoConfiguration implements ApplicationContextAware {

        private final PairProperties properties;
        private final Environment environment;
        private ApplicationContext applicationContext;

        public LoadingCachePairAutoConfiguration(PairProperties properties, Environment environment) {
            this.properties = properties;
            this.environment = environment;
        }

        @Bean
        @Primary
        public LoadingCachePairImpl loadingCachePairImpl() {
            Map<String, Pair> beans = applicationContext.getBeansOfType(Pair.class);
            Pair source;
            if (beans.size() == 1) {
                Collection<Pair> values = beans.values();
                source = values.iterator().next();
            } else {
                String beanName = properties.getDefaultSourceBeanName();
                source = beans.get(beanName);
            }
            if (null == source) {
                return null;
            }
            return new LoadingCachePairImpl(source, properties.getLoadingCacheDurationInMinutes(), TimeUnit.MINUTES);
        }

        @Override
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }
    }
}
