package com.bxm.warcar.integration.autoconfigure.pair;

import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.integration.pair.local.LoadingCachePairImpl;
import com.bxm.warcar.integration.pair.redis.RedisPairImpl;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.JedisPool;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author allen
 * @since 1.0.0
 */
@EnableConfigurationProperties(PairProperties.class)
public class PairAutoConfiguration implements ApplicationContextAware {

    private final PairProperties properties;
    private ApplicationContext applicationContext;

    public PairAutoConfiguration(PairProperties properties) {
        this.properties = properties;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    @ConditionalOnBean(JedisPool.class)
    public RedisPairImpl redisPairImpl(JedisPool jedisPool) {
        return new RedisPairImpl(jedisPool);
    }

    @Bean
    @Primary
    public LoadingCachePairImpl loadingCachePairImpl() {
        Map<String, Pair> beans = applicationContext.getBeansOfType(Pair.class);
        Pair source;
        if (beans.size() == 1) {
            Collection<Pair> values = beans.values();
            source = values.iterator().next();
        } else {
            String beanName = properties.getDefaultSourceBeanName();
            source = beans.get(beanName);
        }
        if (null == source) {
            return null;
        }
        return new LoadingCachePairImpl(source, properties.getLoadingCacheDurationInMinutes(), TimeUnit.MINUTES);
    }
}
