package com.bxm.warcar.integration.autoconfigure.message;

import com.bxm.warcar.integration.message.AsyncMessageProducer;
import com.bxm.warcar.integration.message.MessageProducer;
import com.bxm.warcar.mq.Producer;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ClassUtils;

import java.util.List;
import java.util.Objects;
import java.util.Optional;


/**
 * @author huxiao
 * @date 2019-12-12
 */
@ConditionalOnClass(Producer.class)
@EnableConfigurationProperties(MessageProperties.class)
public class MessageProducerAutoConfiguration {

    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProducerAutoConfiguration.class);

    private final MessageProperties properties;

    public MessageProducerAutoConfiguration(MessageProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(MessageProducer.class)
    public MessageProducer messageProducer(ObjectProvider<List<? extends Producer>> provider) {
        List<? extends Producer> producers = provider.getIfAvailable();

        Producer producer = null;
        Class<? extends Producer> clazzOfProducer = properties.getClazzOfProducer();
        if (null != clazzOfProducer && CollectionUtils.isNotEmpty(producers)) {
            try {
                Optional<? extends Producer> any = producers.stream().filter((o) -> ClassUtils.getUserClass(o).equals(clazzOfProducer)).findAny();
                if (any.isPresent()) {
                    producer = any.get();
                }
            } catch (Throwable throwable) {
                LOGGER.error("", throwable);
                System.exit(-1);
            }
        }

        if (Objects.isNull(producer)) {
            LOGGER.info("Not found any bean of class com.bxm.warcar.mq.Producer.");
            return null;
        }
        return new AsyncMessageProducer(producer);
    }
}
