/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.autoconfigure.pair;

import com.bxm.warcar.integration.autoconfigure.pair.PairProperties;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.integration.pair.local.LoadingCachePairImpl;
import com.bxm.warcar.integration.pair.redis.RedisPairImpl;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.JedisPool;

@EnableConfigurationProperties(value={PairProperties.class})
public class PairAutoConfiguration
implements ApplicationContextAware {
    private final PairProperties properties;
    private ApplicationContext applicationContext;

    public PairAutoConfiguration(PairProperties properties) {
        this.properties = properties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    @ConditionalOnBean(value={JedisPool.class})
    public RedisPairImpl redisPairImpl(JedisPool jedisPool) {
        return new RedisPairImpl(jedisPool);
    }

    @Bean
    @Primary
    public LoadingCachePairImpl loadingCachePairImpl() {
        Pair source;
        Map beans = this.applicationContext.getBeansOfType(Pair.class);
        if (beans.size() == 1) {
            Collection values = beans.values();
            source = (Pair)values.iterator().next();
        } else {
            String beanName = this.properties.getDefaultSourceBeanName();
            source = (Pair)beans.get(beanName);
        }
        if (null == source) {
            return null;
        }
        return new LoadingCachePairImpl(source, this.properties.getLoadingCacheDurationInMinutes(), TimeUnit.MINUTES);
    }
}

