/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.autoconfigure.eventbus;

import com.bxm.warcar.integration.autoconfigure.eventbus.EventParkProperties;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.SyncEventPark;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@EnableConfigurationProperties(value={EventParkProperties.class})
public class EventParkAutoConfiguration {
    private final EventParkProperties properties;

    public EventParkAutoConfiguration(EventParkProperties properties) {
        this.properties = properties;
    }

    @Bean(name={"eventPark", "asyncEventPark"})
    @Primary
    public AsyncEventPark eventPark() {
        int awaitTerminationSeconds = this.properties.getAwaitTerminationSeconds();
        int asyncEventBusPoolSize = this.properties.getAsyncEventBusPoolSize();
        return new AsyncEventPark(asyncEventBusPoolSize, awaitTerminationSeconds);
    }

    @Bean
    public SyncEventPark syncEventPark() {
        return new SyncEventPark();
    }
}

