package com.bxm.warcar.ip.autoconfigure;

import com.bxm.warcar.ip.impl.BaiduIpLibrary;
import com.bxm.warcar.ip.impl.IpIpNetIpLibrary;
import com.bxm.warcar.utils.file.*;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.io.File;

/**
 * @author allen
 * @since V1.0.0 2017/12/14
 */
@Configuration
@EnableConfigurationProperties(IpLibraryConfiguration.class)
public class IpLibraryAutoConfiguration {

    @Autowired
    private IpLibraryConfiguration configuration;

    @Bean("baiduIpLibrary")
    public BaiduIpLibrary baiduIpLibrary() {
        return new BaiduIpLibrary();
    }

    @Bean(name = "ipIpNetIpLibrary", initMethod = "init", destroyMethod = "destroy")
    public IpIpNetIpLibrary ipIpNetIpLibrary() {
        if (StringUtils.equals(configuration.getIpipNetUseType(), IpLibraryConfiguration.USE_TYPE_REMOTE)) {

            FileComparator fileComparator = SystemFileComparatorFactory.create()
                    .fingerprintTracker(new SimpleFingerprintTracker(configuration.getIpipNetFingerprintUrl()))
                    .dataTracker(new SimpleDataTracker(configuration.getIpipNetDataUrl()))
                    .build();

            final IpIpNetIpLibrary library = new IpIpNetIpLibrary(fileComparator.getData());

            FileMonitor fileMonitor = new SystemFileMonitor(fileComparator);
            fileMonitor.addListener(library::refresh);
            fileMonitor.start();

            return library;
        }
        if (StringUtils.equals(configuration.getIpipNetUseType(), IpLibraryConfiguration.USE_TYPE_LOCALFILE)) {
            return new IpIpNetIpLibrary(new File(configuration.getIpipNetFilePath()));
        }
        return null;
    }

    @Bean("ipLibraries")
    public IpLibraries ipLibraries() {
        return new IpLibraries(ipIpNetIpLibrary(), baiduIpLibrary());
    }
}
