package com.bxm.warcar.jmx.autoconfigure;

import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * @author allen
 * @since V1.0.0 2017/12/22
 */
public class EnabledCondition extends SpringBootCondition {

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Object attrName = metadata.getAnnotationAttributes(ConditionalOnEnabled.class.getName()).get("value");
        if (null == attrName) {
            return ConditionOutcome.noMatch("no setting environment 'value'");
        }

        Environment environment = context.getEnvironment();
        String val = environment.getProperty(String.valueOf(attrName));
        boolean enabled = StringUtils.equals("true", val);
        return enabled ? ConditionOutcome.match() : ConditionOutcome.noMatch("disabled.");
    }
}
