package com.bxm.warcar.logging.autoconfigure;

import com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.bxm.warcar.logging.support.AliyunLogServiceLoggingWriter;
import com.bxm.warcar.logging.support.LoggerLoggingWriter;
import com.bxm.warcar.utils.NamedThreadFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author allen
 * @date 2021-07-30
 * @since 1.0
 */
@ConditionalOnClass({LogProducer.class, ProducerConfig.class, ProjectConfig.class})
@EnableConfigurationProperties(AliyunLogServiceProperties.class)
@AutoConfigureAfter(LoggerLoggingWriterAutoConfigure.class)
public class AliyunLogServiceLoggingWriterAutoConfiguration {

    private final AliyunLogServiceProperties properties;

    public AliyunLogServiceLoggingWriterAutoConfiguration(AliyunLogServiceProperties properties) {
        this.properties = properties;
    }

    @Bean
    public AliyunLogServiceLoggingWriter aliyunLogServiceLoggingWriter(LoggerLoggingWriter fallback) {
        ProducerConfig producerConfig = new ProducerConfig();
        ProjectConfig projectConfig = new ProjectConfig(properties.getProject(), properties.getEndpoint(),
                properties.getAccessKeyId(), properties.getAccessKeySecret());
        String logStore = properties.getLogStore();
        AliyunLogServiceLoggingWriter writer = new AliyunLogServiceLoggingWriter(producerConfig, projectConfig, logStore);

        if (properties.isEnableThreadPool()) {
            int coreSize = properties.getCoreSize();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSize, coreSize, 0, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<>(), new NamedThreadFactory("sls-writer"));
            writer.setExecutor(executor);
        }

        writer.setFallback(fallback);

        return writer;
    }
}
