package com.bxm.warcar.message.autoconfigure.dingding;

import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.message.dingding.DingDingMessageSender;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

/**
 * @author allen
 * @since 1.0.0
 */
@Configuration
@EnableConfigurationProperties(DingDingProperties.class)
public class DingDingMessageAutoConfiguration {

    private final DingDingProperties dingDingProperties;

    public DingDingMessageAutoConfiguration(DingDingProperties dingDingProperties) {
        this.dingDingProperties = dingDingProperties;
    }

    @Bean
    @Primary
    public MessageSender dingDingMessageSender() {
        return new DingDingMessageSender(dingDingProperties.getUrl() + dingDingProperties.getToken());
    }
}
