package com.bxm.warcar.message.autoconfigure.email;

import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.message.email.EmailMessageSender;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

/**
 * @author huxiao
 * @date 2024/2/22
 * @since 1.0.0
 */
@EnableConfigurationProperties(EmailProperties.class)
public class EmailMessageAutoConfiguration {

    private final EmailProperties properties;

    public EmailMessageAutoConfiguration(EmailProperties properties) {
        this.properties = properties;
    }

    @Bean
    public MessageSender emailMessageSender() {
        String host = properties.getHost();
        if (StringUtils.isBlank(host)) {
            return null;
        }
        return new EmailMessageSender(host, properties.getPort(), properties.getUsername(), properties.getPassword());
    }
}
