/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.metrics.autoconfigure;

import com.bxm.warcar.metrics.ConsumeTimeMetric;
import com.bxm.warcar.metrics.CounterMetric;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Order(value=-2147483647)
@Aspect
@Configuration
public class MetricsAspect {
    private final ConsumeTimeMetric consumeTimeMetric;
    private final CounterMetric counterMetric;

    public MetricsAspect(ConsumeTimeMetric consumeTimeMetric, CounterMetric counterMetric) {
        this.consumeTimeMetric = consumeTimeMetric;
        this.counterMetric = counterMetric;
    }

    @Around(value="within(@com.bxm.warcar.metrics.annotation.Metrics *)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long start = System.currentTimeMillis();
        Object proceed = point.proceed();
        try {
            String name = this.getServiceName((JoinPoint)point);
            long consumingTime = System.currentTimeMillis() - start;
            this.consumeTimeMetric.submit(name, (double)consumingTime);
            this.counterMetric.increment(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return proceed;
    }

    @AfterThrowing(value="within(@com.bxm.warcar.metrics.annotation.Metrics *))", throwing="throwing")
    public void afterThrowing(JoinPoint point, Throwable throwing) {
        this.counterMetric.decrement(this.getServiceName(point));
    }

    private String getServiceName(JoinPoint point) {
        return point.getSignature().toShortString();
    }
}

