package com.bxm.warcar.micrometer.autoconfigure.ip;

import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.micrometer.ip.IpLibraryMeter;
import com.bxm.warcar.micrometer.ip.IpLibraryMeterAspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2021-04-28
 * @since 1.0
 */
@Configuration
@ConditionalOnClass(IpLibrary.class)
public class IpLibraryMeterAutoConfiguration {

    @Bean
    public IpLibraryMeter ipLibraryMeter(ApplicationContext applicationContext) {
        return new IpLibraryMeter(applicationContext.getBeansOfType(IpLibrary.class).values());
    }

    @Bean
    public IpLibraryMeterAspect ipLibraryMeterAspect(ApplicationContext applicationContext) {
        return new IpLibraryMeterAspect(ipLibraryMeter(applicationContext));
    }
}
