package com.bxm.warcar.micrometer.autoconfigure.mq;

import com.bxm.warcar.micrometer.mq.ProducerMeter;
import com.bxm.warcar.micrometer.mq.ProducerMeterAspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

/**
 * @author allen
 * @date 2019/6/20
 * @since 1.0.0
 */
@ConditionalOnClass(com.bxm.warcar.mq.Producer.class)
public class ProducerAutoMeterConfiguration {

    @Bean
    public ProducerMeter producerMeter() {
        return new ProducerMeter();
    }

    @Bean
    public ProducerMeterAspect producerAspect(ProducerMeter producerMeter) {
        return new ProducerMeterAspect(producerMeter);
    }
}
