package com.bxm.warcar.micrometer.autoconfigure;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author allen
 * @date 2022-04-01
 * @since 1.0
 */
@Data
@ConfigurationProperties(prefix = "warcar.micrometer")
public class MicroMeterProperties {

    /**
     * 应用防护响应时间 Timer 指标 Percentiles 设置。
     * 默认：0.5, 0.75, 0.9, 0.99
     */
    private double[] sentinelRtTimerPercentiles = new double[] {0.5, 0.75, 0.9, 0.99};
}
