package com.bxm.warcar.mq.autoconfigure.alions;

import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.alions.AlionsProducer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.util.Properties;

/**
 * @author allen
 * @date 2017-11-28
 */
@Configuration
@EnableConfigurationProperties({AlionsConfiguration.class, AlionsPropsConfiguration.class})
@ConditionalOnClass(com.aliyun.openservices.ons.api.Producer.class)
public class AlionsAutoConfiguration {

    @Autowired
    private AlionsConfiguration configuration;
    @Autowired
    private AlionsPropsConfiguration propsConfiguration;

    @Bean(initMethod = "start", destroyMethod = "close")
    public Producer alionsProducer() {
        Properties config = propsConfiguration.getConfig();
        if (null != config) {
            return new AlionsProducer(config);
        }

        return new AlionsProducer(configuration.getProducerId(), configuration.getAccessKey(), configuration.getSecretKey());
    }
}
