package com.bxm.warcar.mq.autoconfigure.redis;

import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.AbstractSubscriberHandler;
import com.bxm.warcar.mq.redis.JedisConsumer;
import com.bxm.warcar.mq.redis.JedisProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * @author allen
 * @date 2019/10/21
 * @since 1.0.0
 */
@Configuration
@ConditionalOnClass({JedisPool.class, JedisConfiguration.class})
@EnableConfigurationProperties(JedisConfiguration.class)
public class JedisAutoConfiguration extends AbstractSubscriberHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(JedisAutoConfiguration.class);

    private final JedisConfiguration jedisConfiguration;

    public JedisAutoConfiguration(JedisConfiguration jedisConfiguration) {
        this.jedisConfiguration = jedisConfiguration;
    }

    @Bean
    public JedisPool jedisPool() {
        return new JedisPool(jedisConfiguration, jedisConfiguration.getHost(), jedisConfiguration.getPort(),
                jedisConfiguration.getTimeout(), jedisConfiguration.getPassword(),
                jedisConfiguration.getDatabase());
    }

    @Bean(initMethod = "start", destroyMethod = "close")
    public Producer jedisProducer() {
        return new JedisProducer(jedisPool());
    }

    @Override
    protected Consumer create(String consumerId, Listener messageListener) {
        if (!(messageListener instanceof SingleMessageListener)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("RedisConsumer's message listener must instance of #SingleMessageListener!");
            }
            return null;
        }
        return new JedisConsumer(jedisPool(), (SingleMessageListener) messageListener);
    }
}
