package com.bxm.warcar.boot.tester.ip;

import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.ip.MatchedIpLibrary;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @author allen
 * @since 1.0.0
 */
@SpringBootTest
@RunWith(SpringRunner.class)
public class IpTester {

    @Autowired
    @Qualifier("ipplus360IpLibrary")
    private IpLibrary ipplus;
    @Autowired
    private IpLibrary ipipNet;
    @Autowired
    private MatchedIpLibrary matchedIpLibrary;

    @Test
    public void test() {
        System.out.println(ipplus.find("117.136.79.102"));
        System.out.println(ipplus.find("112.17.87.139"));
        System.out.println(ipplus.find("73.32.192.246"));
        System.out.println(ipplus.find("220.176.34.17"));
        System.out.println(ipplus.find("220.191.32.0"));

        System.out.println(ipplus.find("43.246.231.230"));

        System.out.println(ipplus.find("60.29.19.133"));
        System.out.println(ipipNet.find("60.29.19.133"));

        System.out.println(matchedIpLibrary.find("117.136.79.102").isMatched());
        System.out.println(matchedIpLibrary.find("112.17.87.139").isMatched());
        System.out.println(matchedIpLibrary.find("73.32.192.246").isMatched());
        System.out.println(matchedIpLibrary.find("220.176.34.17").isMatched());
        System.out.println(matchedIpLibrary.find("220.191.32.0").isMatched());
        System.out.println(matchedIpLibrary.find("43.246.231.230").isMatched());

        long begin = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(1000);
        AtomicLong count = new AtomicLong(0);
        int len = 1000000;
        final CountDownLatch latch = new CountDownLatch(len);
        for (int i = 0; i < len; i++) {
            executor.submit(() -> {
                long s = System.currentTimeMillis();
                String ip = getRandomIp();
//                ipipNet.find(ip);
                IP x = ipplus.find(ip);
                System.out.println(count.incrementAndGet() + " - " + (System.currentTimeMillis() - s) + " - " + x);
                latch.countDown();
            });
        }

        try {
            latch.await();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        System.out.println("total consume in " + (System.currentTimeMillis() - begin) + " ms");
        try {
            Thread.sleep(Integer.MAX_VALUE);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String getRandomIp() {
        // ip范围
        int[][] range = { { 607649792, 608174079 }, // 36.56.0.0-36.63.255.255
                { 1038614528, 1039007743 }, // 61.232.0.0-61.237.255.255
                { 1783627776, 1784676351 }, // 106.80.0.0-106.95.255.255
                { 2035023872, 2035154943 }, // 121.76.0.0-121.77.255.255
                { 2078801920, 2079064063 }, // 123.232.0.0-123.235.255.255
                { -1950089216, -1948778497 }, // 139.196.0.0-139.215.255.255
                { -1425539072, -1425014785 }, // 171.8.0.0-171.15.255.255
                { -1236271104, -1235419137 }, // 182.80.0.0-182.92.255.255
                { -770113536, -768606209 }, // 210.25.0.0-210.47.255.255
                { -569376768, -564133889 }, // 222.16.0.0-222.95.255.255
        };

        Random rdint = new Random();
        int index = rdint.nextInt(10);
        return num2ip(range[index][0] + new Random().nextInt(range[index][1] - range[index][0]));
    }

    /**
     * 将十进制转换成IP地址
     */
    public static String num2ip(int ip) {
        int[] b = new int[4];
        String x = "";
        b[0] = (int) ((ip >> 24) & 0xff);
        b[1] = (int) ((ip >> 16) & 0xff);
        b[2] = (int) ((ip >> 8) & 0xff);
        b[3] = (int) (ip & 0xff);
        x = Integer.toString(b[0]) + "." + Integer.toString(b[1]) + "." + Integer.toString(b[2]) + "." + Integer.toString(b[3]);
        return x;
    }
}
