package com.bxm.warcar.boot.tester.mq.ons;

import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.Subscriber;
import com.bxm.warcar.mq.autoconfigure.SubscriberWrapper;
import com.bxm.warcar.utils.StringHelper;

@Subscriber
public class OnsListener implements SubscriberWrapper, SingleMessageListener {

    @Override
    public String getConsumerId() {
        return "CID_BXM_WARCAR_TEST";
    }

    @Override
    public String getTopic() {
        return "BXM_WARCAR_TEST";
    }

    @Override
    public ConsumeStatus consume(Message message, Object context) {
        byte[] body = message.getBody();
        System.out.println(StringHelper.convert(body));
        return ConsumeStatus.CONSUME_SUCCESS;
    }
}
