package com.bxm.warcar.boot.tester;

import com.bxm.warcar.boot.tester.config.TesterProperties;
import com.bxm.warcar.boot.tester.eventbus.OneEventObject;
import com.bxm.warcar.boot.tester.eventbus.TwoEventObject;
import com.bxm.warcar.integration.eventbus.EventPark;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;

/**
 * @author allen
 * @since 1.0.0
 */
@SpringBootApplication
@EnableConfigurationProperties(TesterProperties.class)
public class TesterApplication {

    public static void main(String[] args) {
        ConfigurableApplicationContext context = SpringApplication.run(TesterApplication.class, args);

        EventPark eventPark = context.getBean(EventPark.class);
        eventPark.post(new OneEventObject("one"));
        eventPark.post(new TwoEventObject("two"));
    }
}
