package com.bxm.warcar.boot.tester.mq;

import com.bxm.warcar.boot.tester.config.TesterProperties;
import com.bxm.warcar.integration.taskcounter.TaskCounter;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.Subscriber;
import com.bxm.warcar.mq.autoconfigure.SubscriberWrapper;
import com.bxm.warcar.utils.StringHelper;

@Subscriber
public class CachePushListener implements SingleMessageListener, SubscriberWrapper {

    private final TesterProperties properties;

    public CachePushListener(TesterProperties properties) {
        this.properties = properties;
    }

    @Override
    public String getTopic() {
        return properties.getTopic();
    }

    @Override
    @TaskCounter
    public ConsumeStatus consume(Message message, Object context) {
        String msgId = message.getMsgId();
        System.out.println(msgId + " Starting process");
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
            ;
        }
        System.out.println(StringHelper.convert(message.getBody()));
        System.out.println(msgId + " Finished process!");
        return ConsumeStatus.CONSUME_SUCCESS;
    }

    @Override
    public String getConsumerId() {
        return properties.getConsumerId();
    }
}
