package com.bxm.warcar.web.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.utils.IpHelper;
import com.bxm.warcar.web.cache.local.LocalCache;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * <h3>Ip拦截器</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/03/07 10:18
 */

public class IpInterceptor implements HandlerInterceptor {

	private static final Logger LOGGER = LoggerFactory.getLogger(IpInterceptor.class);
	private static final String ALL= "*";
	private static final int DURATION_TIME= 30;

	private LocalCache localCache;

	public IpInterceptor(JedisPool jedisPool){
		this.localCache= new LocalCache(jedisPool,DURATION_TIME, TimeUnit.MINUTES) ;
	}

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

		try {
			String ip = IpHelper.getIpFromHeader(request);

			if (StringUtils.isBlank(ip)){
				return true;
			}

			String ipkey = IpHelper.getIpNoDotTwo(ip);
			String ipvalue = localCache.get(ipkey);

			if (StringUtils.isBlank(ipvalue)){
				return true;
			}

			if (ALL.equals(ipvalue)){
				response.setStatus(HttpServletResponse.SC_FORBIDDEN);
				return false;
			}

			List<String> list  = JSONObject.parseArray(ipvalue,String.class);
			if (CollectionUtils.isEmpty(list)){
				return true;
			}
			LOGGER.info("list is {},ip  is {}",list,ip);
			if (list.contains(ip)){
				response.setStatus(HttpServletResponse.SC_FORBIDDEN);
				return false;
			}
		}catch (Exception e){
			LOGGER.error(" Resolving IP exceptions !",e);
		}
		return true;
	}


	@Override
	public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,  ModelAndView modelAndView) throws Exception {

	}


	@Override
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {

	}
}
