/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.web.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.utils.IpHelper;
import com.bxm.warcar.web.cache.local.LocalCache;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import redis.clients.jedis.JedisPool;

public class IpInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpInterceptor.class);
    private static final String ALL = "*";
    private static final int DURATION_TIME = 30;
    private LocalCache localCache;

    public IpInterceptor(JedisPool jedisPool) {
        this.localCache = new LocalCache(jedisPool, 30, TimeUnit.MINUTES);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            String ip = IpHelper.getIpFromHeader((HttpServletRequest)request);
            if (StringUtils.isBlank((String)ip)) {
                return true;
            }
            String ipkey = IpHelper.getIpNoDotTwo((String)ip);
            String ipvalue = this.localCache.get(ipkey);
            if (StringUtils.isBlank((String)ipvalue)) {
                return true;
            }
            if (ALL.equals(ipvalue)) {
                response.setStatus(403);
                return false;
            }
            List list = JSONObject.parseArray((String)ipvalue, String.class);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return true;
            }
            LOGGER.info("list is {},ip  is {}", (Object)list, (Object)ip);
            if (list.contains(ip)) {
                response.setStatus(403);
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error(" Resolving IP exceptions !", (Throwable)e);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

