package com.bxm.warcar.web.bo;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;

import java.io.Serializable;
import java.util.*;

/**
 * 广告位监控对象bo
 * <p>
 *     业务处理逻辑不应该放到基础框架里面来，该逻辑已经迁走，此处代码作废
 * </p>
 *
 * @Author kk.xie
 * @Date 2019/11/25 17:12
 * @Version 1.0
 **/
@Deprecated
public class PositionMonitorBo implements Serializable {
    public static final String IP = "IP";
    public static final String UID = "UID";
    private static final long serialVersionUID = -2150559929809588794L;

    private boolean ticketNotLimit;

    /**处理策略*/
    private final Set<MonitorEnum> processMode = new HashSet();

    private final Map<MonitorEnum, Set> map = new HashedMap();

    public PositionMonitorBo() {
        MonitorEnum[] monitorEnums = MonitorEnum.values();
        for (MonitorEnum monitorEnum : monitorEnums) {
            map.put(monitorEnum, new HashSet());
        }
    }


    public Set getSet(MonitorEnum monitorEnum){
        return map.get(monitorEnum);
    }

    public void removeSet(MonitorEnum monitorEnum){
        map.remove(monitorEnum);
        processMode.remove(monitorEnum);
    }

    public void removeAllMonitorSet(){
        MonitorEnum[] values = MonitorEnum.values();
        for (MonitorEnum value : values) {
            if(MonitorEnum.MONITOR_GRANULARITY.equals(value)){
                continue;
            }
            map.remove(value);
            processMode.remove(value);
        }
    }

    public void removeAllSet(){
        MonitorEnum[] values = MonitorEnum.values();
        for (MonitorEnum value : values) {
            map.remove(value);
            processMode.remove(value);
        }
    }

    public boolean add(MonitorEnum monitorEnum, Object obj){
        if(Objects.isNull(obj)){
            return true;
        }

        Set set = map.get(monitorEnum);
        if(Objects.isNull(set)){
            set = new HashSet();
        }
        processMode.add(monitorEnum);
        set.add(obj);

        return true;
    }

    public boolean addAll(MonitorEnum monitorEnum, Collection collection){
        if(CollectionUtils.isEmpty(collection)){
            return true;
        }

        Set set = map.get(monitorEnum);
        if(Objects.isNull(set)){
            set = new HashSet();
        }
        processMode.add(monitorEnum);
        set.addAll(collection);
        return true;
    }

    public boolean isTicketNotLimit() {
        return ticketNotLimit;
    }

    public void setTicketNotLimit(boolean ticketNotLimit) {
        this.ticketNotLimit = ticketNotLimit;
    }

    public Set<MonitorEnum> getProcessMode() {
        return processMode;
    }

    public Map<MonitorEnum, Set> getMap() {
        return map;
    }

    public enum MonitorEnum {
        /**
         * 广告券监控策略
         */
        TICKET_ID,
        /**
         * 结算类型
         */
        ACCOUNT_TYPE,
        /**
         * 备用券
         */
        BACK_TICKET,
        /**
         * 监控粒度
         */
        MONITOR_GRANULARITY
    }
}
