package com.bxm.warcar.web.autoconfigure;

import com.bxm.warcar.web.util.EncryptedControllerMethodAspect;
import com.bxm.warcar.web.util.Encryptor;
import com.bxm.warcar.web.util.EncryptorFactory;
import com.bxm.warcar.web.util.aes.AesEncryptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

import java.util.Map;

/**
 * @author allen
 * @date 2020-10-10
 * @since 1.0
 */
public class EncryptedAutoConfiguration {

    @Bean
    public AesEncryptor aesEncryptor() {
        return new AesEncryptor();
    }

    @Bean
    public EncryptorFactory encryptorFactory(ApplicationContext applicationContext) {
        Map<String, Encryptor> beans = applicationContext.getBeansOfType(Encryptor.class);
        return new EncryptorFactory(beans.values());
    }

    @Bean
    public EncryptedControllerMethodAspect encryptedControllerMethodAspect(ObjectProvider<EncryptorFactory> encryptorFactoryObjectProvider) {
        return new EncryptedControllerMethodAspect(encryptorFactoryObjectProvider.getIfAvailable());
    }
}
