package com.bxm.warcar.zk.autoconfigure;

import com.bxm.warcar.zk.ZkClientHolder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

/**
 * @author allen
 * @since 1.0.0
 */
@EnableConfigurationProperties(ZkProperties.class)
@ConditionalOnProperty(name = ZkProperties.PREFIX + ".servers")
public class ZkAutoConfiguration {

    private final ZkProperties properties;

    public ZkAutoConfiguration(ZkProperties properties) {
        this.properties = properties;
    }

    @Bean(initMethod = "init", destroyMethod = "destroy")
    public ZkClientHolder zkClientHolder() {
        return new ZkClientHolder(properties.getServers(), properties.getSessionTimeout());
    }
}
