/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.id.autoconfigure.redis;

import com.bxm.warcar.id.autoconfigure.redis.JedisConfiguration;
import com.bxm.warcar.id.redis.RedisIdGenerator;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Configuration
@ConditionalOnClass(value={JedisPool.class, Jedis.class})
@EnableConfigurationProperties(value={JedisConfiguration.class})
public class RedisIdGeneratorConfiguration {
    private final JedisConfiguration configuration;

    public RedisIdGeneratorConfiguration(JedisConfiguration jedisConfiguration) {
        this.configuration = jedisConfiguration;
    }

    @Bean
    @ConditionalOnMissingBean(value={JedisPool.class})
    public JedisPool jedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.configuration, this.configuration.getHost(), this.configuration.getPort(), this.configuration.getTimeout(), this.configuration.getPassword(), this.configuration.getDatabase());
    }

    @Primary
    @Bean
    public RedisIdGenerator redisIdGenerator(JedisPool jedisPool) {
        return new RedisIdGenerator(jedisPool);
    }
}

