package com.bxm.user.id.generator;

import java.util.Objects;

/**
 * 设备帮助类
 *
 * @author allen
 * @date 2021-07-01
 * @since 1.0.0
 */
public final class DeviceHelper {

    /**
     * 根据设备信息返回一个 Uid，设备信息不变的情况下，Uid也不会变。
     *
     * @param deviceInfo 设备信息
     * @return UID
     */
    public static String getUid(DeviceInfo deviceInfo){
        String uid;
        switch (deviceInfo.getOs()){
            case DeviceInfo.OS_ANDROID:
                uid = getFirst(deviceInfo.getImei(), deviceInfo.getImeiMd5(),
                        deviceInfo.getAnid(), deviceInfo.getAnidMd5(),
                        deviceInfo.getOaid(), deviceInfo.getOaidMd5());
                break;
            case DeviceInfo.OS_IOS:
                uid = getFirst(deviceInfo.getIdfa(), deviceInfo.getIdfaMd5());
                break;
            case DeviceInfo.OS_UNKNOWN:
            default:
                uid = getFirst(deviceInfo.getImei(), deviceInfo.getImeiMd5(),
                        deviceInfo.getAnid(), deviceInfo.getAnidMd5(),
                        deviceInfo.getOaid(), deviceInfo.getOaidMd5(),
                        deviceInfo.getIdfa(), deviceInfo.getIdfaMd5());
                break;
        }
        return uid;
    }

    private static String getFirst(String... strings){
        for (String str : strings) {
            if (Objects.nonNull(str) && str.trim().length() > 0) {
                return str;
            }
        }
        return null;
    }
}
