package com.bxm.user.id.generator;

/**
 * 设备信息
 *
 * @author allen
 * @date 2021-07-01
 * @since 1.0
 */
public class DeviceInfo {

    /**
     * 未知
     */
    public static final int OS_UNKNOWN = 0;
    /**
     * Android
     */
    public static final int OS_ANDROID = 1;
    /**
     * iOS
     */
    public static final int OS_IOS = 2;

    /**
     * 系统类型
     * @see  #OS_UNKNOWN
     * @see  #OS_ANDROID
     * @see  #OS_IOS
     */
    private int os = OS_UNKNOWN;
    /**
     * IMEI
     */
    private String imei;
    /**
     * IMEI
     */
    private String imeiMd5;
    /**
     * 安卓ID
     */
    private String anid;
    /**
     * 安卓ID
     */
    private String anidMd5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    /**
     * oaid md5
     */
    private String oaidMd5;
    /**
     * IDFA
     */
    private String idfa;
    /**
     * IDFA
     */
    private String idfaMd5;
    /**
     * IPv4 / IPv6
     */
    private String ip;
    /**
     * User-Agent
     */
    private String ua;

    public int getOs() {
        return os;
    }

    public DeviceInfo setOs(int os) {
        this.os = os;
        return this;
    }

    public String getImei() {
        return imei;
    }

    public DeviceInfo setImei(String imei) {
        this.imei = imei;
        return this;
    }

    public String getImeiMd5() {
        return imeiMd5;
    }

    public DeviceInfo setImeiMd5(String imeiMd5) {
        this.imeiMd5 = imeiMd5;
        return this;
    }

    public String getAnid() {
        return anid;
    }

    public DeviceInfo setAnid(String anid) {
        this.anid = anid;
        return this;
    }

    public String getAnidMd5() {
        return anidMd5;
    }

    public DeviceInfo setAnidMd5(String anidMd5) {
        this.anidMd5 = anidMd5;
        return this;
    }

    public String getOaid() {
        return oaid;
    }

    public DeviceInfo setOaid(String oaid) {
        this.oaid = oaid;
        return this;
    }

    public String getOaidMd5() {
        return oaidMd5;
    }

    public DeviceInfo setOaidMd5(String oaidMd5) {
        this.oaidMd5 = oaidMd5;
        return this;
    }

    public String getIdfa() {
        return idfa;
    }

    public DeviceInfo setIdfa(String idfa) {
        this.idfa = idfa;
        return this;
    }

    public String getIdfaMd5() {
        return idfaMd5;
    }

    public DeviceInfo setIdfaMd5(String idfaMd5) {
        this.idfaMd5 = idfaMd5;
        return this;
    }

    public String getIp() {
        return ip;
    }

    public DeviceInfo setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String getUa() {
        return ua;
    }

    public DeviceInfo setUa(String ua) {
        this.ua = ua;
        return this;
    }

    @Override
    public String toString() {
        return "DeviceInfo{" +
                "os=" + os +
                ", imei='" + imei + '\'' +
                ", imeiMd5='" + imeiMd5 + '\'' +
                ", anid='" + anid + '\'' +
                ", anidMd5='" + anidMd5 + '\'' +
                ", oaid='" + oaid + '\'' +
                ", oaidMd5='" + oaidMd5 + '\'' +
                ", idfa='" + idfa + '\'' +
                ", idfaMd5='" + idfaMd5 + '\'' +
                ", ip='" + ip + '\'' +
                ", ua='" + ua + '\'' +
                '}';
    }
}
