/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.vision.data.sdk.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.bxm.vision.data.sdk.WebProperties;
import com.bxm.vision.data.sdk.autoconfigure.DotSupport;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.integration.dc.dot.DotParameter;
import com.bxm.warcar.integration.dc.dot.DotParameterFactory;
import com.bxm.warcar.integration.dc.dot.ModelTypeEnum;
import com.bxm.warcar.utils.IpHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.util.ContentCachingRequestWrapper;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class IpInterceptor
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpInterceptor.class);
    private static final String RESPONSE_MODEL = "\",\"success\":true,\"error\":false,\"code\":1,\"message\":\"ip\"}";
    private static final String UID = "uid";
    private static final String APPKEY = "appkey";
    private static final String COUNTID = "countId";
    private static final String BUSINESS = "business";
    private static final String CLICK_HEAD = "clickMsg";
    private static final int CLICK_DB_INDEX = 11;
    private static final int CLICK_EXPIRE = 259200;
    private final WebProperties webProperties;
    private final JedisFetcher sentinelJedisFetcher;
    private final JedisFetcher visionJedisFetcher;
    private final DotSupport dotSupport;
    private final JedisUpdater jedisUpdater;
    private final JedisFetcher jedisFetcher;

    public IpInterceptor(JedisFetcher sentinelJedisFetcher, JedisFetcher visionJedisFetcher, WebProperties webProperties, DotSupport dotSupport, JedisUpdater jedisUpdater, JedisFetcher jedisFetcher) {
        this.webProperties = webProperties;
        this.sentinelJedisFetcher = sentinelJedisFetcher;
        this.visionJedisFetcher = visionJedisFetcher;
        this.dotSupport = dotSupport;
        this.jedisUpdater = jedisUpdater;
        this.jedisFetcher = jedisFetcher;
    }

    public boolean preHandle(HttpServletRequest req, HttpServletResponse response, Object handler) throws Exception {
        try {
            ContentCachingRequestWrapper request = new ContentCachingRequestWrapper(req);
            if (!this.isOpenFilter()) {
                return true;
            }
            if (this.ignore((HttpServletRequest)request)) {
                return true;
            }
            if (this.preidIgnore((HttpServletRequest)request)) {
                return true;
            }
            String ip = StringUtils.defaultIfEmpty((String)IpHelper.getIpFromHeader((HttpServletRequest)request), (String)"");
            String uid = StringUtils.defaultIfEmpty((String)this.getValue((HttpServletRequest)request, UID), (String)"");
            boolean cheatIp = this.checkIpCheat(ip);
            boolean cheatUid = this.checkUidCheat(uid);
            if (!cheatIp && !cheatUid) {
                return true;
            }
            byte[] body = IpInterceptor.getBodyForBuffer((HttpServletRequest)request);
            JSONObject json = new JSONObject();
            if (ArrayUtils.isNotEmpty((byte[])body)) {
                json = JSONObject.parseObject((String)StringHelper.convert((byte[])body));
            }
            String appkey = StringUtils.defaultIfEmpty((String)this.getValue((HttpServletRequest)request, APPKEY), (String)"");
            String business = StringUtils.defaultIfEmpty((String)this.getValue((HttpServletRequest)request, BUSINESS), (String)"");
            HashMap map = Maps.newHashMap();
            this.banned(map, cheatIp, cheatUid);
            String countid = this.getValue((HttpServletRequest)request, COUNTID);
            String modeltype = this.getValue((HttpServletRequest)request, "modeltype");
            boolean isShowOrClickEvent = StringUtils.isNotBlank((String)countid);
            if (isShowOrClickEvent) {
                this.setBxmId((HttpServletRequest)request, ip, appkey, business, countid, modeltype);
                this.markCheatOnThisBxmId(countid);
                this.sendNormalLog((HttpServletRequest)request, map);
            } else {
                if (!this.isMarkCheatOnThisBxmId(this.getValue((HttpServletRequest)request, json, "bxm_id"))) {
                    return true;
                }
                this.sendEffectLog((HttpServletRequest)request, json, map);
            }
            IpInterceptor.print(response, countid);
            return false;
        }
        catch (Exception e) {
            LOGGER.error(" Resolving IP exceptions !", (Throwable)e);
            return true;
        }
    }

    private void sendNormalLog(HttpServletRequest request, Map<String, String> map) {
        this.dotSupport.asyncDoGet(request, map);
    }

    private void sendEffectLog(HttpServletRequest request, JSONObject json, Map<String, String> map) {
        String modeltype = this.getValue(request, json, "modeltype");
        if (StringUtils.isBlank((String)modeltype) || !"7".equals(modeltype)) {
            return;
        }
        String bxmId = this.getValue(request, json, "bxm_id");
        DotParameterFactory parameterFactory = DotParameterFactory.create().bxmid(bxmId).modelType(modeltype).mt(ModelTypeEnum._1).status(this.getValue(request, json, "status")).sh(json.getInteger("sh")).sw(json.getInteger("sw")).ts(json.getLong("ts")).locaurl(this.getValue(request, json, "locaurl")).referrer(request.getHeader("referrer"));
        String result = (String)this.jedisFetcher.fetchWithSelector(() -> KeyBuilder.build((Object[])new Object[]{CLICK_HEAD, bxmId}), String.class, 11);
        if (StringUtils.isNotBlank((String)result)) {
            String[] results = result.split(":");
            try {
                parameterFactory.ip(results[0]);
                parameterFactory.appkey(results[1]);
                parameterFactory.business(results[2]);
                parameterFactory.activityId((Object)results[3]);
                parameterFactory.awardId((Object)results[4]);
                parameterFactory.uid(results[5]);
                parameterFactory.assetsId((Object)results[6]);
                parameterFactory.ua(results[8]);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
        DotParameter parameter = parameterFactory.build();
        parameter.put((Object)"fmModelId", (Object)request.getParameter("fmModelId"));
        parameter.put((Object)"banned", (Object)map.get("banned"));
        parameter.put((Object)"did", (Object)request.getParameter("did"));
        String type = this.getValue(request, json, "type");
        if (StringUtils.isNotBlank((String)type)) {
            parameter.put((Object)"ext", (Object)("beType:" + type));
        }
        this.dotSupport.asyncDoGetEffect(parameter);
    }

    private String getValue(HttpServletRequest request, JSONObject jsonObject, String key) {
        String value = request.getParameter(key);
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        return jsonObject.getString(key);
    }

    private void markCheatOnThisBxmId(String bxmId) {
        Object clientOriginal = this.visionJedisFetcher.getClientOriginal();
        JedisPool jedisPool = (JedisPool)clientOriginal;
        try (Jedis jedis = jedisPool.getResource();){
            jedis.select(5);
            String key = "cheat:" + bxmId;
            jedis.set(key, "1");
            jedis.expire(key, 691200);
        }
    }

    private boolean isMarkCheatOnThisBxmId(String bxmId) {
        Object clientOriginal = this.visionJedisFetcher.getClientOriginal();
        JedisPool jedisPool = (JedisPool)clientOriginal;
        try (Jedis jedis = jedisPool.getResource();){
            jedis.select(5);
            String key = "cheat:" + bxmId;
            boolean bl = jedis.exists(key);
            return bl;
        }
    }

    private void setBxmId(HttpServletRequest request, String ip, String appkey, String business, String countid, String modeltype) {
        if (!"7".equals(modeltype)) {
            return;
        }
        String value = KeyBuilder.build((Object[])new Object[]{ip, appkey, business, this.getValue(request, "activityid"), this.getValue(request, "preid"), this.getValue(request, UID), this.getValue(request, "assetsId"), this.getValue(request, "appos"), this.getValue(request, "ua")});
        this.jedisUpdater.updateWithSelector(() -> KeyBuilder.build((Object[])new Object[]{CLICK_HEAD, countid}), (Object)value, 259200, 11);
    }

    private boolean ignore(HttpServletRequest request) {
        WebProperties.Ip ip = this.webProperties.getIp();
        if (null == ip) {
            return false;
        }
        Map<String, Set<String>> ignoreParameters = ip.getIgnoreParameters();
        if (MapUtils.isNotEmpty(ignoreParameters)) {
            for (Map.Entry<String, Set<String>> entry : ignoreParameters.entrySet()) {
                String key = entry.getKey();
                String pvalue = request.getParameter(key);
                if (!entry.getValue().contains(pvalue)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean preidIgnore(HttpServletRequest request) {
        String preids = (String)this.visionJedisFetcher.fetch(() -> KeyBuilder.build((Object[])new Object[]{"PREID", "WHITELIST", "CACHE"}), String.class);
        if (Objects.isNull(preids)) {
            return false;
        }
        String preid = request.getParameter("preid");
        if (Objects.isNull(preid)) {
            return false;
        }
        return Arrays.asList(preids.split(",")).contains(preid);
    }

    private boolean checkUidCheat(String uid) {
        return StringUtils.isNotBlank((String)uid) && Objects.nonNull(this.visionJedisFetcher.fetch(() -> StringUtils.join((Object[])new String[]{"CHEAT", "UID", uid}, (String)":"), Object.class));
    }

    private boolean checkIpCheat(String ip) {
        return StringUtils.isNotBlank((String)ip) && Objects.nonNull(this.visionJedisFetcher.fetch(() -> StringUtils.join((Object[])new String[]{"CHEAT", "IP", ip}, (String)":"), Object.class));
    }

    private String getValue(HttpServletRequest request, String key) {
        return request.getParameter(key);
    }

    private boolean isOpenFilter() {
        Boolean isOpenFilter = (Boolean)this.sentinelJedisFetcher.fetch(() -> "AD:CHEAT:FLOW:FILTER:OPTION", Boolean.class);
        return Boolean.TRUE.equals(isOpenFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBodyForBuffer(HttpServletRequest request) {
        byte[] byArray;
        ServletInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            inputStream = request.getInputStream();
            outputStream = new ByteArrayOutputStream();
            int len = -1;
            byte[] buff = new byte[2048];
            while ((len = inputStream.read(buff)) != -1) {
                outputStream.write(buff, 0, len);
            }
            outputStream.flush();
            byArray = outputStream.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("read request input stream occur error!", (Throwable)e);
                }
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            return byArray2;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(HttpServletResponse response, String data) {
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            response.setStatus(200);
            writer.print("{\"data\":\"" + data + RESPONSE_MODEL);
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.error(" Resolving IP write !", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    private void banned(Map<String, String> map, boolean cheatIp, boolean cheatUid) {
        if (cheatIp) {
            map.put("banned", "1");
        }
        if (cheatUid) {
            map.put("banned", "2");
        }
        if (cheatIp && cheatUid) {
            map.put("banned", "3");
        }
    }
}

