/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.vision.data.sdk.autoconfigure;

import com.bxm.warcar.integration.dc.dot.AsyncDot;
import com.bxm.warcar.integration.dc.dot.DotParameter;
import com.bxm.warcar.integration.dc.dot.DotParameterFactory;
import com.bxm.warcar.integration.dc.dot.ModelTypeEnum;
import com.bxm.warcar.integration.dc.dot.VerEnum;
import com.bxm.warcar.utils.IpHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DotSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DotSupport.class);
    private final AsyncDot asyncDot;

    public DotSupport(AsyncDot asyncDot) {
        this.asyncDot = asyncDot;
    }

    public void asyncDoGet(HttpServletRequest request, Map<String, String> map) {
        String modeltype = request.getParameter("modeltype");
        if (StringUtils.isBlank((CharSequence)modeltype)) {
            return;
        }
        ModelTypeEnum modelTypeEnum = DotSupport.of(modeltype);
        if (null == modelTypeEnum) {
            return;
        }
        String business = request.getParameter("business");
        if (StringUtils.isNotBlank((CharSequence)business)) {
            business = business.replaceAll("ad-|money-", "money-");
        }
        String refer = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("referrer"), (CharSequence)request.getHeader("referer"));
        DotParameterFactory factory = DotParameterFactory.create((VerEnum)VerEnum.V2).ip(IpHelper.getIpFromHeader((HttpServletRequest)request)).userAgent(request.getHeader("user-agent")).referrer(refer).bxmid(request.getParameter("countId")).price(Long.valueOf(NumberUtils.toLong((String)request.getParameter("offerPrice")))).mt(modelTypeEnum).popupId((Object)request.getParameter("popupId")).awardId((Object)request.getParameter("preid")).assetsId((Object)request.getParameter("assetsId")).scene(String.valueOf(request.getParameter("scene"))).ts(Long.valueOf(System.currentTimeMillis())).appkey(request.getParameter("appkey")).business(business).activityId((Object)request.getParameter("activityid")).uid(request.getParameter("uid")).spm(request.getParameter("spm")).imei(request.getParameter("i")).idfa(request.getParameter("f")).ext(request.getParameter("ext")).toType(this.parseDomain(request.getHeader("Origin")));
        String random3 = request.getParameter("random3");
        if (StringUtils.isNotBlank((CharSequence)random3) && random3.split(",").length == 2) {
            factory.sw(Integer.valueOf(NumberUtils.toInt((String)random3.split(",")[0])));
            factory.sh(Integer.valueOf(NumberUtils.toInt((String)random3.split(",")[1])));
        }
        DotParameter dotParameter = factory.build();
        dotParameter.put((Object)"fmModelId", (Object)request.getParameter("fmModelId"));
        dotParameter.put((Object)"banned", (Object)map.get("banned"));
        dotParameter.put((Object)"did", (Object)request.getParameter("did"));
        dotParameter.put((Object)"device", (Object)request.getParameter("device"));
        this.asyncDot.asyncDoGet(dotParameter);
    }

    public void asyncDoGetEffect(DotParameter parameter) {
        this.asyncDot.asyncDoGet(parameter);
    }

    private static ModelTypeEnum of(String modeltype) {
        try {
            for (ModelTypeEnum modelTypeEnum : ModelTypeEnum.values()) {
                if (Integer.parseInt(modeltype) != modelTypeEnum.getOriginal()) continue;
                return modelTypeEnum;
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Unknown model type of: {}", (Object)modeltype);
            return null;
        }
        return null;
    }

    private String parseDomain(String origin) {
        if (StringUtils.isBlank((CharSequence)origin)) {
            return null;
        }
        try {
            return new URL(origin).getHost();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

