/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.vision.data.sdk.autoconfigure.dot;

import com.bxm.vision.data.sdk.autoconfigure.DotSupport;
import com.bxm.vision.data.sdk.autoconfigure.dot.VisionDotProperties;
import com.bxm.warcar.integration.dc.dot.AsyncDot;
import com.bxm.warcar.integration.dc.dot.Dot;
import com.bxm.warcar.integration.dc.dot.impl.DefaultDotImpl;
import com.bxm.warcar.integration.dc.dot.impl.ThreadPoolExecutorDotImpl;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={VisionDotProperties.class})
public class VisionDotAutoConfiguration {
    private final VisionDotProperties properties;

    public VisionDotAutoConfiguration(VisionDotProperties properties) {
        this.properties = properties;
    }

    @Bean
    public AsyncDot visionAsyncDot() {
        VisionDotProperties.ThreadPoolProperties threadPool = this.properties.getThreadPool();
        return new ThreadPoolExecutorDotImpl((Dot)new DefaultDotImpl(this.properties.getUrl()), threadPool.getPoolCoreSize(), threadPool.getAwaitTerminationTimeInSeconds());
    }

    @Bean
    public DotSupport dotSupport() {
        return new DotSupport(this.visionAsyncDot());
    }
}

