/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.vision.data.sdk.autoconfigure.jedis;

import com.bxm.vision.data.sdk.autoconfigure.jedis.JedisOldConfiguration;
import com.bxm.vision.data.sdk.autoconfigure.jedis.JedisSentinelConfiguration;
import com.bxm.vision.data.sdk.autoconfigure.jedis.JedisVisionConfiguration;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(value={JedisVisionConfiguration.class, JedisSentinelConfiguration.class, JedisOldConfiguration.class})
public class JedisAutoConfiguration {
    @Autowired
    private JedisSentinelConfiguration sentinelConfiguration;
    @Autowired
    private JedisVisionConfiguration visionConfiguration;
    @Autowired
    private JedisOldConfiguration oldConfiguration;

    @Bean
    public JedisPool sentinelJedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.sentinelConfiguration, this.sentinelConfiguration.getHost(), this.sentinelConfiguration.getPort(), this.sentinelConfiguration.getTimeout(), this.sentinelConfiguration.getPassword(), this.sentinelConfiguration.getDatabase());
    }

    @Bean
    public JedisFetcher sentinelJedisFetcher() {
        JedisFetcher jedisFetcher = new JedisFetcher(this.sentinelJedisPool());
        return jedisFetcher;
    }

    @Bean
    public JedisPool visionJedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.visionConfiguration, this.visionConfiguration.getHost(), this.visionConfiguration.getPort(), this.visionConfiguration.getTimeout(), this.visionConfiguration.getPassword(), this.visionConfiguration.getDatabase());
    }

    @Bean
    public JedisFetcher visionJedisFetcher() {
        JedisFetcher jedisFetcher = new JedisFetcher(this.visionJedisPool());
        return jedisFetcher;
    }

    @Bean
    public JedisPool oldJedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.oldConfiguration, this.oldConfiguration.getHost(), this.oldConfiguration.getPort(), this.oldConfiguration.getTimeout(), this.oldConfiguration.getPassword(), this.oldConfiguration.getDatabase());
    }

    @Bean
    public JedisUpdater oldJedisUpdater() {
        JedisUpdater jedisUpdater = new JedisUpdater(this.oldJedisPool());
        return jedisUpdater;
    }

    @Bean
    public JedisFetcher oldJedisFetcher() {
        JedisFetcher jedisFetcher = new JedisFetcher(this.oldJedisPool());
        return jedisFetcher;
    }
}

