/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.vision.data.sdk.interceptor;

import com.bxm.vision.data.sdk.WebProperties;
import com.bxm.vision.data.sdk.autoconfigure.DotSupport;
import com.bxm.vision.data.sdk.interceptor.IpInterceptor;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnWebApplication
@ConditionalOnBean(value={JedisFetcher.class})
@EnableConfigurationProperties(value={WebProperties.class})
public class WebIpInterceptorAutoConfiguration
implements WebMvcConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebIpInterceptorAutoConfiguration.class);
    private final JedisFetcher sentinelJedisFetcher;
    private final JedisFetcher visionJedisFetcher;
    private final WebProperties webProperties;
    private final DotSupport dotSupport;
    private final JedisUpdater jedisUpdater;
    private final JedisFetcher jedisFetcher;

    @Autowired
    public WebIpInterceptorAutoConfiguration(WebProperties webProperties, @Qualifier(value="sentinelJedisFetcher") JedisFetcher sentinelJedisFetcher, @Qualifier(value="visionJedisFetcher") JedisFetcher visionJedisFetcher, DotSupport dotSupport, @Qualifier(value="oldJedisUpdater") JedisUpdater jedisUpdater, @Qualifier(value="oldJedisFetcher") JedisFetcher jedisFetcher) {
        this.webProperties = webProperties;
        this.visionJedisFetcher = visionJedisFetcher;
        this.sentinelJedisFetcher = sentinelJedisFetcher;
        this.dotSupport = dotSupport;
        this.jedisUpdater = jedisUpdater;
        this.jedisFetcher = jedisFetcher;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        List<String> exclusions = this.webProperties.getIp().getExclusions();
        if (CollectionUtils.isNotEmpty(exclusions)) {
            LOGGER.info("The ip com.bxm.vision.data.sdk.interceptor exclusions: {}", exclusions);
        }
        registry.addInterceptor((HandlerInterceptor)this.ipInterceptor()).addPathPatterns(new String[]{"/**"}).excludePathPatterns(exclusions);
    }

    @Bean
    public IpInterceptor ipInterceptor() {
        return new IpInterceptor(this.sentinelJedisFetcher, this.visionJedisFetcher, this.webProperties, this.dotSupport, this.jedisUpdater, this.jedisFetcher);
    }
}

