package com.bxm.vision.manager.common.exception;

/**
 * 异常
 *
 * @Author kk.xie
 * @Date 2019/02/13 16:39
 * @Version 1.0
 **/
public class EngineManagerException extends RuntimeException{
    private static final long serialVersionUID = -1457484658601940112L;
    /**
     * 错误编码
     */
    private Integer errorCode;

    public EngineManagerException(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public EngineManagerException(String message) {
        super(message);
    }

    public EngineManagerException(String message, Integer errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    public EngineManagerException(String message, Throwable cause, Integer errorCode) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public EngineManagerException(Throwable cause, Integer errorCode) {
        super(cause);
        this.errorCode = errorCode;
    }

    public EngineManagerException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, Integer errorCode) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.errorCode = errorCode;
    }

    public Integer getErrorCode() {
        return errorCode;
    }
}
