/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.algorithm.flow;

import com.bxm.warcar.algorithm.flow.filter.AbstractFilter;
import com.bxm.warcar.algorithm.flow.filter.ClassifyFilter;
import com.bxm.warcar.algorithm.flow.filter.DistributionFilter;
import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class FlowFilterChain
implements Interceptor,
ApplicationListener<ContextRefreshedEvent> {
    private final List<Interceptor> interceptors = Lists.newArrayList();
    @Autowired
    private ClassifyFilter classifyFilter;
    @Autowired
    private DistributionFilter distributionFilter;

    public void intercept(Invocation invocation) {
        this.interceptors.get(0).intercept(invocation);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.interceptors.size() == 0) {
            this.addInterceptors();
        }
    }

    private void addInterceptors() {
        this.interceptors.add((Interceptor)this.classifyFilter);
        this.interceptors.add((Interceptor)this.distributionFilter);
        FlowFilterChain.setChain(this.interceptors);
    }

    private static void setChain(List<Interceptor> interceptors) {
        for (int i = 0; i < interceptors.size(); ++i) {
            boolean isLast;
            Interceptor interceptor = interceptors.get(i);
            if (!(interceptor instanceof AbstractFilter)) continue;
            boolean bl = isLast = i + 1 == interceptors.size();
            if (isLast) continue;
            ((AbstractFilter)interceptor).setNextInterceptor(interceptors.get(i + 1));
        }
    }
}

