package com.bxm.warcar.algorithm.flow.filter;

import com.bxm.warcar.algorithm.RequestModel;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Invocation;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/04/17 13:44
 */
public abstract class AbstractFilter extends AbstractInterceptor {

	@Override
	protected void doIntercept(Invocation invocation) {
		if (invocation == null){
			return;
		}

		if (invocation.getRequestModel()==null || !(invocation.getRequestModel() instanceof RequestModel)){
			return;
		}

		RequestModel requestModel = (RequestModel)invocation.getRequestModel();

		doFilter(requestModel);
	}


	/**
	 * 具体业务处理
	 * @param requestModel
	 */
	protected  abstract void doFilter (RequestModel requestModel);

}
