package com.bxm.warcar.algorithm.chance;

import com.bxm.warcar.algorithm.utils.DoubleUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.stereotype.Service;
import java.util.Map;
import java.util.Set;

/**
 * <h3>按照比率+概率出最有机会的</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/04/17 14:57
 */
@Service
public class ChanceServiceImpl implements ChanceService {

	@Override
	public String get(Map<String, Double> map) {

		if (MapUtils.isEmpty(map)){
			return null;
		}

		double chanceRate = RandomUtils.nextDouble(0,sum(map));
		Set<Map.Entry<String, Double>>  entrySet = map.entrySet();
		double rate = 0.0;
		for ( Map.Entry<String, Double> entry :entrySet){
			rate = DoubleUtils.add(rate,entry.getValue());
			if (rate>=chanceRate){
				return  entry.getKey();
			}
		}
		return entrySet.iterator().next().getKey();
	}

	private static double sum(Map<String, Double> rates){
		double sum = 0.0;
		for(Double d:rates.values()){
			if(d>0) {
				sum = DoubleUtils.add(sum,d);
			}
		}
		return sum;
	}
}
