/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.algorithm.flow.filter;

import com.bxm.warcar.algorithm.NumericalModel;
import com.bxm.warcar.algorithm.RequestModel;
import com.bxm.warcar.algorithm.config.NumericalConfiguration;
import com.bxm.warcar.algorithm.flow.filter.AbstractFilter;
import com.bxm.warcar.algorithm.utils.DoubleUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DistributionFilter
extends AbstractFilter {
    private static final double DEFAULT_RATE = 1.0;
    @Autowired
    private NumericalConfiguration numericalConfiguration;

    @Override
    protected void doFilter(RequestModel requestModel) {
        List<NumericalModel> testList = requestModel.getTestList();
        List<NumericalModel> formalList = requestModel.getFormalList();
        if (CollectionUtils.isEmpty(formalList)) {
            if (CollectionUtils.isEmpty(testList)) {
                return;
            }
            this.doTestFlow(testList, 1.0);
            return;
        }
        if (CollectionUtils.isEmpty(testList)) {
            if (CollectionUtils.isEmpty(formalList)) {
                return;
            }
            this.doFormalFlow(formalList, 1.0);
            return;
        }
        double allTestFlowRate = this.doTestFlow(testList, this.numericalConfiguration.getTestFlow());
        double formalFlow = DoubleUtils.subtract(1.0, allTestFlowRate);
        this.doFormalFlow(formalList, formalFlow);
    }

    private double doTestFlow(List<NumericalModel> testList, double rate) {
        double allFlowRate = 0.0;
        NumericalModel numericalModel = testList.get(0);
        this.testFlow(numericalModel, rate);
        for (int i = 0; i < testList.size(); ++i) {
            NumericalModel model = testList.get(i);
            model.setFlowRate(numericalModel.getFlowRate());
            allFlowRate += model.getFlowRate();
            if (!(allFlowRate + model.getFlowRate() > rate)) continue;
            return allFlowRate;
        }
        if (rate < 1.0) {
            return allFlowRate;
        }
        if (allFlowRate + numericalModel.getFlowRate() < rate) {
            double averageFlowRate = DoubleUtils.divide(rate, testList.size());
            for (int i = 0; i < testList.size(); ++i) {
                NumericalModel model = testList.get(i);
                model.setFlowRate(averageFlowRate);
            }
            allFlowRate = rate;
        }
        return allFlowRate;
    }

    private void testFlow(NumericalModel model, double rate) {
        long preDatePv = model.getPreGroupDatePv();
        if (preDatePv < this.numericalConfiguration.getDefaultOpenPv()) {
            preDatePv = this.numericalConfiguration.getDefaultOpenPv();
        }
        double flowRate = DoubleUtils.divide(this.numericalConfiguration.getThreshold3(), preDatePv);
        model.setFlowRate(flowRate);
    }

    private void doFormalFlow(List<NumericalModel> formalList, double rate) {
        if (formalList.size() == 1) {
            NumericalModel model = formalList.get(0);
            model.setFlowRate(rate);
            return;
        }
        for (int i = 0; i < formalList.size(); ++i) {
            NumericalModel model = formalList.get(i);
            if (i == formalList.size() - 1) {
                double personalFactor = this.numericalConfiguration.getPersonalFactor();
                double flowRate = DoubleUtils.multiply(rate, DoubleUtils.pow(DoubleUtils.subtract(1.0, personalFactor), i));
                model.setFlowRate(flowRate);
                continue;
            }
            this.formalFlow(model, rate, i);
        }
    }

    private void formalFlow(NumericalModel model, double rate, int i) {
        double personalFactor = this.numericalConfiguration.getPersonalFactor();
        double flowRate = DoubleUtils.multiply(rate, DoubleUtils.pow(DoubleUtils.subtract(1.0, personalFactor), i), personalFactor);
        model.setFlowRate(flowRate);
    }
}

