/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.warcar.aspect.before;
import com.bxm.warcar.aspect.LogAspect;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

import java.lang.reflect.Method;

/**
 * <h3>操作之前日志记录</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/02/07 15:22
 */
@Aspect
public class LogBeforeAspect extends LogAspect {

    @Before("@annotation(com.bxm.warcar.aspect.before.LogBefore)")
    public void doBefore(JoinPoint point){
        try {
            //开始时间
            long startTime = System.currentTimeMillis();

            Method method = getMethod(point);
            if(null == method){
                if(logger.isWarnEnabled()){
                    logger.warn("method is null");
                }
                return;
            }

            LogBefore logMessge = method.getAnnotation(LogBefore.class);

            //获取所有的参数
            String params = getParams(point);

            String user = logMessge.user();
            if(StringUtils.isBlank(user)){
                user = getUser(point);
            }

            logger.info("操作人：{}，\n 操作内容：{},\n 参数：{}," +
                    "\n 系统是：{},\n 总耗时：{}s",
                    user,logMessge.operType(),params,logMessge.keyName(),excTime(startTime));
        }catch (Exception e){
            logger.error("记录日志异常",e);
        }
    }

}