/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.warcar.aspect.around;

import com.bxm.warcar.aspect.before.LogBefore;

import java.lang.annotation.*;

/**
 *<h3>方法环绕操作日志记录</h3>
 * <p>如果想使用广告操作前记录请使用{@link LogBefore}</p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/02/07 15:22
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface LogAround {

	/**
	 * @return 要记录系统的名称。
	 */
	String keyName();

	/**
	 * @return 操作类型
	 */
	String operType() default "";

	/**
	 * @return 操作人
	 */
	String user() default "";

}
