package com.bxm.warcar.cache;

import java.util.Map;

/**
 * 计数器
 *
 * @author allen
 * @date 2017-12-04
 */
public interface Counter {

    Long incrementAndGet(KeyGenerator keyGenerator);

    Long incrementAndGet(KeyGenerator keyGenerator, int expireTimeInSecond);

    Long incrementByAndGet(KeyGenerator keyGenerator, long inc);

    Long incrementByAndGet(KeyGenerator keyGenerator, long inc, int expireTimeInSecond);

    /**
     * 浮点值的原子操作<br/>
     *
     * @param keyGenerator
     * @param inc
     * @return
     */
    Double incrFloatByAndGet(KeyGenerator keyGenerator, double inc);

    /**
     * 浮点值的原子操作<br/>
     *
     * @param keyGenerator
     * @param inc
     * @param expireTimeInSecond
     * @return
     */
    Double incrFloatByAndGet(KeyGenerator keyGenerator, double inc, int expireTimeInSecond);

    Long decrementAndGet(KeyGenerator keyGenerator);

    Long decrementAndGet(KeyGenerator keyGenerator, int expireTimeInSecond);

    Long decrementByAndGet(KeyGenerator keyGenerator, long dec);

    Long decrementByAndGet(KeyGenerator keyGenerator, long dec, int expireTimeInSecond);

    void set(KeyGenerator keyGenerator, long value);

    /**
     * 重新设置redis key的过期时间<br/>
     *
     * @param keyGenerator
     * @param seconds
     * @return
     */
    void expire(KeyGenerator keyGenerator, int seconds);

    Long get(KeyGenerator keyGenerator);

    Long hincrementAndGet(KeyGenerator keyGenerator, String field);

    Long hincrementAndGet(KeyGenerator keyGenerator, String field, int expireTimeInSecond);

    Long hincrementByAndGet(KeyGenerator keyGenerator, String field, long inc);

    Long hincrementByAndGet(KeyGenerator keyGenerator, String field, long inc, int expireTimeInSecond);

    /**
     * 浮点值的原子操作<br/>
     *
     * @param keyGenerator
     * @param field
     * @param inc
     * @return
     */
    Double hincrFloatByAndGet(KeyGenerator keyGenerator, String field, double inc);

    /**
     * 浮点值的原子操作<br/>
     *
     * @param keyGenerator
     * @param field
     * @param inc
     * @param expireTimeInSecond
     * @return
     */
    Double hincrFloatByAndGet(KeyGenerator keyGenerator, String field, double inc, int expireTimeInSecond);

    Long hget(KeyGenerator keyGenerator, String field);

    Map<String, Long> hgetall(KeyGenerator keyGenerator);

    /**
     * <p>对应key的值进行 -1，如果key不存在，初始化值为{@link DefaultValTrackable#getDefaultVal()}。减后的值如果小于<code>min</code>，那么抛出{@link ValueOutOfLimitException}。</p>
     * <b>这个方法未经多线程压测，属于Beta版，请酌情使用。</b>
     * @param keyGenerator
     * @param defaultValTrackable 初始值
     * @param min 最小值限制
     * @param expireTimeInSecond 设置过期时间
     * @return 返回更新后的值
     * @throws IllegalStateException 当内部对key的值进行修改时，如果发现该值已经被其他线程修改，造成的并发问题将抛出这个异常。
     * @throws ValueOutOfLimitException 当操作后的值小于<code>min</code>则抛出该异常。
     */
    Long decrementAndGet(KeyGenerator keyGenerator, DefaultValTrackable defaultValTrackable, long min, int expireTimeInSecond) throws IllegalStateException, ValueOutOfLimitException;

    /**
     * 返回这个获取器具体的实现原生客户端
     * @return
     */
    Object getClientOriginal();
}
