/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.cache;

import com.bxm.warcar.cache.impls.redis.JedisWindowed;

/**
 * @author allen
 * @since 1.0.0
 */
public interface Windowed {

    /**
     * 执行增量计算
     *
     * @param incr 增量值
     * @return 当前窗口增量后的值
     */
    double execute(double incr);

    /**
     * 返回所有窗口的统计结果
     *
     * @return 统计结果
     */
    double get();

    /**
     * 销毁当前内存中的线程和数据
     */
    void destroy();

    String getPrimary();

    JedisWindowed.Duration getWindowLength();

    JedisWindowed.Duration getSlidingInterval();

    String getCurrentWindowed();
}
