/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.configure.test;

import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.configure.test.ConfigureProperties;
import com.bxm.warcar.configure.test.Configures;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;

@RefreshScope
@RestController
public class ConfigureController {
    private final ConfigurableEnvironment environment;
    private final ConfigureProperties configureProperties;
    private final Fetcher fetcher;
    private final Configures configures;
    @Value(value="${configure.el:12}")
    private String el;

    public ConfigureController(ConfigurableEnvironment environment, ConfigureProperties configureProperties, Fetcher fetcher, Configures configures) {
        this.environment = environment;
        this.configureProperties = configureProperties;
        this.fetcher = fetcher;
        this.configures = configures;
    }

    @GetMapping(value={"/"})
    public ResponseEntity<Object> getEnvironment() {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        for (PropertySource propertySource : propertySources) {
            if (!propertySource.getName().startsWith("userRemoteDefinedProperties")) continue;
            return ResponseEntity.ok((Object)propertySource);
        }
        return ResponseEntity.ok((Object)propertySources);
    }

    @GetMapping(value={"/config"})
    public ResponseEntity<Object> config() {
        return ResponseEntity.ok((Object)this.configureProperties);
    }

    @GetMapping(value={"/els"})
    public ResponseEntity<Object> els() {
        return ResponseEntity.ok((Object)this.configures.getDemo());
    }

    @GetMapping(value={"/keys"})
    public ResponseEntity<Object> keys() {
        Map map = this.fetcher.hfetchall(() -> "AD:TICKET:AVAILABLE", String.class);
        return ResponseEntity.ok((Object)map);
    }

    @PutMapping(value={"/put"})
    public ResponseEntity<Boolean> put(String key, String value) {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        for (PropertySource propertySource : propertySources) {
            Object properties;
            if (!propertySource.getName().startsWith("userRemoteDefinedProperties") || !((properties = propertySource.getSource()) instanceof Properties)) continue;
            ((Properties)properties).put(key, value);
            return ResponseEntity.ok((Object)true);
        }
        return ResponseEntity.ok((Object)false);
    }
}

