/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.configure.loader;

import com.bxm.warcar.configure.loader.AbstractEnvironmentLoader;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheEnvironmentLoader
extends AbstractEnvironmentLoader {
    private static final Logger log = LoggerFactory.getLogger(AbstractCacheEnvironmentLoader.class);
    private File cacheDir;
    private final boolean enableCache = this.createCacheDirIfNecessary();

    public AbstractCacheEnvironmentLoader(String address, String[] keys) {
        super(address, keys);
    }

    protected abstract byte[] readSource0(String var1);

    @Override
    protected byte[] readSource(String key) {
        if (!this.enableCache) {
            return this.readSource0(key);
        }
        byte[] source0 = this.readSource0(key);
        if (source0 != null) {
            this.writeCacheFile(key, source0);
            return source0;
        }
        return this.readCacheFile(key);
    }

    private byte[] readCacheFile(String key) {
        File cacheFile = new File(this.cacheDir, key);
        try {
            if (cacheFile.exists()) {
                byte[] bytes = FileUtils.readFileToByteArray((File)cacheFile);
                log.info("Successful read configure data length {} byte from file: {}", (Object)bytes.length, (Object)cacheFile.getAbsolutePath());
                return bytes;
            }
        }
        catch (IOException e) {
            log.error("readCacheFile: ", (Throwable)e);
        }
        return null;
    }

    private void writeCacheFile(String key, byte[] source) {
        File cacheFile = new File(this.cacheDir, key);
        try {
            FileUtils.writeByteArrayToFile((File)cacheFile, (byte[])source);
            log.info("Successful write configure to file: {}", (Object)cacheFile.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("writeCacheFile: ", (Throwable)e);
        }
    }

    private boolean createCacheDirIfNecessary() {
        block5: {
            String tmpdir = System.getProperty("user.home") + File.separator + ".warcar" + File.separator + "configure" + File.separator;
            this.cacheDir = new File(tmpdir);
            if (!this.cacheDir.exists()) {
                try {
                    if (!this.cacheDir.mkdirs()) {
                        throw new IOException("\u65e0\u6cd5\u521b\u5efa\u76ee\u5f55\uff1a" + this.cacheDir.getAbsolutePath());
                    }
                    break block5;
                }
                catch (IOException | SecurityException e) {
                    log.warn("\u65e0\u6cd5\u521b\u5efa\u76ee\u5f55\uff1a" + this.cacheDir.getAbsolutePath(), (Throwable)e);
                    return false;
                }
            }
            if (!this.cacheDir.isDirectory()) {
                log.warn("\u6587\u4ef6\u8def\u5f84 {} \u5df2\u7ecf\u5b58\u5728\uff0c\u4e14\u4e0d\u662f\u76ee\u5f55\u3002\u6240\u4ee5\u4e0d\u652f\u6301\u914d\u7f6e\u7f13\u5b58\u672c\u5730\u529f\u80fd\u3002", (Object)this.cacheDir.getAbsolutePath());
                return false;
            }
        }
        return true;
    }
}

