package com.bxm.warcar.datasync.client.cache;

import com.bxm.warcar.datasync.utils.KeyHelper;

/**
 * 缓存
 * @author allen
 * @date 2019/4/3
 * @since 1.0.0
 */
public interface Cache {

    /**
     * 从缓存中获取指定 key 的对象。
     * @param key key
     * @return 有可能为 null
     * @throws NullPointerException key is null
     * @see KeyHelper
     */
    <T> T get(String key) throws NullPointerException;

    /**
     * 返回这个缓存大小
     * @return 缓存大小
     */
    long size();
}
