package com.bxm.warcar.datasync.client.cache;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

import java.util.concurrent.ConcurrentHashMap;

/**
 * @author allen
 * @date 2019/4/3
 * @since 1.0.0
 */
public class ConcurrentHashMapCacheImpl implements MutableCache {

    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap<>();

    @Override
    public Object set(String key, Object value) throws NullPointerException {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "key");
        Preconditions.checkNotNull(value, "value");
        return cache.put(key, value);
    }

    @Override
    public void del(String key) {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "key");
        cache.remove(key);
    }

    @Override
    public <T> T get(String key) throws NullPointerException {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "key");
        return (T) cache.get(key);
    }

    @Override
    public long size() {
        return cache.size();
    }
}
