package com.bxm.warcar.datasync.server;


import com.bxm.warcar.datasync.serialization.Serialization;
import com.bxm.warcar.datasync.server.sync.SyncController;
import com.bxm.warcar.datasync.server.sync.SyncOperationException;
import com.bxm.warcar.datasync.source.SourceController;
import com.bxm.warcar.datasync.source.SourceOperationException;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

/**
 * @author allen
 * @date 2019/4/2
 * @since 1.0.0
 */
public class DefaultDataSyncProducer implements DataSyncProducer {

    private final SyncController syncController;
    private final SourceController sourceController;
    private final Serialization serialization = new Serialization() {
    };

    public DefaultDataSyncProducer(SyncController syncController, SourceController sourceController) {
        Preconditions.checkNotNull(syncController);
        Preconditions.checkNotNull(sourceController);
        this.syncController = syncController;
        this.sourceController = sourceController;
    }

    @Override
    public void post(String key, Object value) throws SourceOperationException, SyncOperationException, IllegalArgumentException {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "key");
        Preconditions.checkNotNull(value, "value");
        if (!sourceController.set(key, serialization.serialize(value))) {
            throw new SourceOperationException();
        }
        if (!syncController.update(key, value.getClass())) {
            throw new SyncOperationException();
        }
    }

    @Override
    public void delete(String key) {
        sourceController.delete(key);
        syncController.delete(key);
    }
}
