/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.datasync.client.triggers.zk;

import com.bxm.warcar.datasync.client.Action;
import com.bxm.warcar.datasync.client.Trigger;
import com.bxm.warcar.datasync.serialization.Serialization;
import com.bxm.warcar.datasync.server.sync.SyncCache;
import com.bxm.warcar.datasync.source.SourceController;
import com.bxm.warcar.zk.listener.ChildrenChangedListener;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkChildrenChangedListener
implements ChildrenChangedListener,
Trigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZkChildrenChangedListener.class);
    private final Action action;
    private final SourceController sourceController;
    private final Serialization serialization = new Serialization(){};

    public ZkChildrenChangedListener(Action action, SourceController sourceController) {
        Preconditions.checkNotNull((Object)action);
        Preconditions.checkNotNull((Object)sourceController);
        this.action = action;
        this.sourceController = sourceController;
    }

    public void add(String path, byte[] data) {
        block2: {
            try {
                SyncCache syncCache = SyncCache.of(data);
                String key = syncCache.getId();
                String value = this.fetch(key);
                this.action.add(key, this.serialization.deserialize(value, syncCache.getCls()));
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("add: " + path, (Throwable)e);
            }
        }
    }

    public void remove(String path, byte[] data) {
        block2: {
            try {
                SyncCache syncCache = SyncCache.of(data);
                String key = syncCache.getId();
                this.action.remove(key);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("remove: " + path, (Throwable)e);
            }
        }
    }

    public void update(String path, byte[] data) {
        block2: {
            try {
                SyncCache syncCache = SyncCache.of(data);
                String key = syncCache.getId();
                String value = this.fetch(key);
                this.action.update(key, this.serialization.deserialize(value, syncCache.getCls()));
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("update: " + path, (Throwable)e);
            }
        }
    }

    private String fetch(String key) {
        return this.sourceController.get(key);
    }
}

