/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.datasync.client.cache;

import com.bxm.warcar.datasync.client.cache.MutableCache;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadingCacheImpl
implements MutableCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadingCacheImpl.class);
    private final LoadingCache<String, Optional<Object>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Optional<Object>>(){

        public Optional<Object> load(String key) throws Exception {
            return Optional.empty();
        }
    });

    @Override
    public Object set(String key, Object value) throws NullPointerException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        String old = (String)this.get(key);
        try {
            Optional<Object> optional = Optional.of(value);
            this.cache.put((Object)key, optional);
        }
        catch (Exception e) {
            LOGGER.error("set: ", (Throwable)e);
        }
        return old;
    }

    @Override
    public void del(String key) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        try {
            this.cache.refresh((Object)key);
        }
        catch (Exception e) {
            LOGGER.error("del: ", (Throwable)e);
        }
    }

    @Override
    public <T> T get(String key) throws NullPointerException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        try {
            Optional optional = (Optional)this.cache.get((Object)key);
            return optional.orElse(null);
        }
        catch (ExecutionException e) {
            LOGGER.error("cache get: ", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("get: ", (Throwable)e);
        }
        return null;
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public Map<String, Object> getAll() {
        throw new UnsupportedOperationException();
    }
}

